<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Calculator\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Calculate the result
 *
 * @param string $operation Mathematical operation
 * @since 1.0.0
 *
 * @return string
 */
function automatorwp_calculator_calculate_result( $operation ) {

    require_once AUTOMATORWP_CALCULATOR_DIR . 'vendor/autoload.php';
    
    $calc_obj = new ChrisKonnertz\StringCalc\StringCalc();

    try{
        $operation_result = $calc_obj->calculate( $operation );
    } catch (Exceptions\StringCalcException $exception) {
        $operation_result = sprintf( __( "%s", 'automatorwp-pro'), $exception->getMessage() );
    } catch (\Exception $exception) {
        $operation_result = sprintf( __( "%s", 'automatorwp-pro'), $exception->getMessage() );
    }
    
    
    return $operation_result;
    
}
